/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.cec;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.HSCVPD;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.console.OmConsoleMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50Define;
import com.ibm.hsc.rep.v50.R50HscInfo;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;

public class OmCecHscInfoUpdater {
    private static final String LOCALHOST_IP = "127.0.0.1";
    private OmCecMgr mCecMgr;

    public OmCecHscInfoUpdater(OmCecMgr omCecMgr) {
        this.mCecMgr = omCecMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBasicHscInfo() throws RException, PIHscServerException {
        String string;
        Object object;
        Object object2;
        HSCVPD hSCVPD = null;
        try {
            hSCVPD = new HSCVPD();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new PIHscServerException("1781");
        }
        String string2 = "";
        String string3 = "";
        if (hSCVPD.isVPDPresent()) {
            string2 = hSCVPD.getHSCModel();
            string3 = hSCVPD.getHSCSerialNumber();
            object2 = string2 + "*" + string3;
            this.createOrUpdateHscInfo("HscName", (String)object2);
        } else {
            System.out.println("ERROR: Failed to create hsc info for HscName. NO VPD Present..");
        }
        try {
            int n;
            object2 = InetAddress.getLocalHost().getHostAddress();
            object = InetAddress.getLocalHost().getHostName();
            string = this.getHscAddIPs();
            if (object2 == null || ((String)object2).equals(LOCALHOST_IP)) {
                n = string.indexOf(",");
                if (n > 0) {
                    object2 = string.substring(0, n);
                } else if (!string.equals("")) {
                    object2 = string;
                }
            }
            n = 0;
            if (object != null) {
                n = ((String)object).length();
            }
            this.createOrUpdateHscInfo("HscHostName", (String)object);
            n = 0;
            if (object2 != null) {
                n = ((String)object2).length();
            }
            this.createOrUpdateHscInfo("HscIPAddr", (String)object2);
            this.createOrUpdateHscInfo("HscAddIPs", string);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            throw new PIHscServerException("138F");
        }
        object2 = null;
        object = new FspLockHelper(this.mCecMgr.getFspLockMgr(), 0);
        try {
            ((FspLockHelper)object).addNvramLock(this.mCecMgr.getObjectId());
            ((FspLockHelper)object).lock(1, 1);
            object2 = this.mCecMgr.getSaveArea().getSystemCredentialInfo();
        }
        catch (Throwable throwable) {
            System.out.println("failure when calling getSystemCredentialInfo(): " + throwable);
        }
        finally {
            try {
                ((FspLockHelper)object).unlock();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (object2 != null) {
            string = "";
            if (((Vector)object2).size() > 0) {
                string = (String)((Vector)object2).elementAt(0);
            }
            System.out.println("CredID=" + string);
            this.createOrUpdateHscInfo("CredID", string);
        }
    }

    public String getHscAddIPs() throws PIHscServerException {
        Object object;
        StringBuffer stringBuffer;
        block13: {
            Object object2;
            stringBuffer = new StringBuffer();
            try {
                String string;
                object = "/opt/hsc/data/HscAddIPs";
                BufferedReader bufferedReader = new BufferedReader(new FileReader((String)object));
                while ((string = bufferedReader.readLine()) != null) {
                    object2 = string.trim();
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append((String)object2);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                object = Runtime.getRuntime();
                long l = System.currentTimeMillis();
                object2 = ((Runtime)object).exec("lshmc -n -Fipaddrlpar");
                Thread thread = new Thread((Process)object2){
                    private final /* synthetic */ Process val$p;
                    {
                        this.val$p = process;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            1.sleep(OmConsoleMgr.GettingIpAddrLparTimeoutInSec * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        finally {
                            this.val$p.destroy();
                        }
                    }
                };
                System.out.println("exec command: lshmc -n -Fipaddrlpar");
                thread.start();
                int n = ((Process)object2).waitFor();
                long l2 = System.currentTimeMillis();
                System.out.println("lshmc exit value=" + n);
                if (l2 - l < (long)((OmConsoleMgr.GettingIpAddrLparTimeoutInSec - 1) * 1000)) {
                    if (n != 0) break block13;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object2).getInputStream()));
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            String string2 = string.trim();
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(string2);
                        }
                    }
                    catch (IOException iOException) {
                        System.out.println("error in reading ipaddr - ignored");
                    }
                    bufferedReader.close();
                    break block13;
                }
                System.out.println("lshmc times out: " + (l2 - l));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        object = stringBuffer.toString();
        if (stringBuffer.length() == 0) {
            object = this.getLastHscAddIPs();
            System.out.println("use last HscAddIPs if any: " + (String)object);
        } else {
            System.out.println("HscAddIPs=" + (String)object);
        }
        return object;
    }

    public void createOrUpdateHscInfo(String string, String string2) throws RException {
        RObject rObject;
        RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_HscInfo);
        rObjectId.setKeyValue(0, "IBMHSC_ComputerSystem");
        rObjectId.setKeyValue(1, this.mCecMgr.getCecName());
        rObjectId.setKeyValue(2, string);
        RObject rObject2 = rObject = rObjectId.getObject();
        if (rObject2 == null) {
            rObject2 = new RObject(rObjectId);
        }
        rObject2.setProperty(R50HscInfo.Index_Data, (Object)string2);
        int n = 0;
        if (string2 != null) {
            n = string2.length();
        }
        rObject2.setProperty(R50HscInfo.Index_DataLength, (Object)new UnsignedInt16(n));
        if (rObject == null) {
            rObject2.addInstance();
        } else {
            rObject2.setInstance();
        }
        RObject rObject3 = this.mCecMgr.getObject();
        if (!rObject3.hasAssociation(R50Define.AID_IBMHSC_CompSysHscInfo, rObjectId)) {
            rObject3.addAssociation(R50Define.AID_IBMHSC_CompSysHscInfo, rObjectId);
        }
    }

    public void deleteHscInfo(String string) throws RException {
        RObjectId rObjectId = new RObjectId(1, R50Define.CID_IBMHSC_HscInfo);
        rObjectId.setKeyValue(0, "IBMHSC_ComputerSystem");
        rObjectId.setKeyValue(1, this.mCecMgr.getCecName());
        rObjectId.setKeyValue(2, string);
        RObject rObject = rObjectId.getObject();
        if (rObject != null) {
            rObject.deleteInstance();
        }
    }

    public String constructHscInfo() throws RException, PIHscServerException {
        return this.constructHscInfo(null, null);
    }

    public String constructHscInfo(String string, String string2) throws RException, PIHscServerException {
        RObject rObject = this.mCecMgr.getObject();
        Vector vector = rObject.associators(R50Define.AID_IBMHSC_CompSysHscInfo);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < vector.size(); ++i) {
            RObject rObject2 = (RObject)vector.elementAt(i);
            String string3 = (String)rObject2.getProperty(R50HscInfo.Index_DataTag);
            String string4 = (String)rObject2.getProperty(R50HscInfo.Index_Data);
            if (string != null && string.equals(string3)) {
                bl = true;
                string4 = string2;
            }
            if (string3.equals("RMCKey")) {
                bl2 = true;
            }
            stringBuffer.append(string3);
            stringBuffer.append("=");
            if (string4 != null) {
                stringBuffer.append(string4);
            }
            stringBuffer.append(";");
        }
        if (!bl2) {
            stringBuffer.append("RMCKey=;");
        }
        if (!bl && string != null) {
            stringBuffer.append(string);
            stringBuffer.append("=");
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }

    private String getLastHscAddIPs() {
        String string;
        block3: {
            string = "";
            try {
                RObject rObject = this.mCecMgr.getObject();
                Vector vector = rObject.associators(R50Define.AID_IBMHSC_CompSysHscInfo);
                if (vector == null) break block3;
                for (int i = 0; i < vector.size(); ++i) {
                    RObject rObject2 = (RObject)vector.elementAt(i);
                    String string2 = (String)rObject2.getProperty(R50HscInfo.Index_DataTag);
                    if (!string2.equals("HscAddIPs")) continue;
                    string = (String)rObject2.getProperty(R50HscInfo.Index_Data);
                    break;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.out.println("Exp ignored.");
            }
        }
        return string;
    }

    public void pushAndUpdateHscInfo(String string, String string2) throws RException, PIHscServerException, PIHscCmdMgrException {
        System.out.println("[OM]pushAndUpdateHscInfo: " + string + "=" + string2);
        if (this.mCecMgr.isHypervisorRunning()) {
            FspCmdHelper fspCmdHelper = this.mCecMgr.getCmdHelper();
            String string3 = this.constructHscInfo(string, string2);
            System.out.println("hscInfoData=[" + string3 + "]");
            fspCmdHelper.setHmcInfo(new UnsignedInt16(65535), ByteUtilities.toHexString(string3.getBytes()));
            this.createOrUpdateHscInfo(string, string2);
        } else {
            System.out.println("[OM]failed to set HMC Info because phyp is not ready.");
        }
    }

    public void pushHscInfo() throws RException, PIHscServerException, PIHscCmdMgrException {
        System.out.println("[OM]pushHscInfo");
        if (this.mCecMgr.isHypervisorRunning()) {
            FspCmdHelper fspCmdHelper = this.mCecMgr.getCmdHelper();
            this.updateBasicHscInfo();
            String string = this.constructHscInfo();
            System.out.println("hscInfoData=[" + string + "]");
            fspCmdHelper.setHmcInfo(new UnsignedInt16(65535), ByteUtilities.toHexString(string.getBytes()));
        } else {
            System.out.println("[OM]failed to set HMC Info because phyp is not ready");
        }
    }
}

